pico-8 cartridge // http://www.pico-8.com
version 38
__lua__
--vars
function _init()
		part={}
		parts = true
		cartdata("possiblyaxolotl_beancompletion")
		pos="front"
		lastlevel=0
		fadedir = -2
		fadepos = 20
		currentlevel = 0
		num=0
		loops=0
		val="warp to area"
		bgclr = 12
		startclr=1
  player={
    sp=1,
    x=59,
    y=59,
    w=8,
    h=8,
    flp=false,
    dx=0,
    dy=0,
    max_dx=2,
    max_dy=3,
    acc=0.5,
    boost=4,
    anim=0,
    running=false,
    jumping=false,
    falling=false,
    sliding=false,
    landed=false
  }

  gravity=0.3
  friction=0.85

  --simple camera
  cam_x=0
		cam_y=128
		
  --map limits
  map_start=0
  map_end=1024
  r_edge = 128
  
  start=false
  
  lvlup(currentlevel)
end

function main()
	load("beanmenu.p8")
end

--menuitem(4,"⌂exit to menu⌂",main)
menuitem(5,"----------")
-->8
--update and draw

--cam_y=128 brings the cam
--down to lvl2
function playupdate()
		
		if parts == true then
			updateparts()
		end

  player_update()
  player_animate()

  --simple camera
  cam_x=player.x-64+(player.w/2)
  if cam_x<map_start then
     cam_x=map_start
  end
  if cam_x>map_end-r_edge then
     cam_x=map_end-r_edge
  end
  
  cam_y=player.y-64+(player.w/2)
  if cam_y<map_top then
     cam_y=map_top
  end
  if cam_y>map_top-map_bottom then
     cam_y=map_top-map_bottom
  end
  camera(cam_x,cam_y)
end

function enddraw()
	fade()
	cls(12)
	camera(0,0)
	print("your time is ⧗"..endtime.."⧗ seconds!",16,16)
	print("i never finished this project",16,24)
	print("hope it was still good",16,32)
	spr(128,0,0,8,8)
end

function endupdate()
end

function playdraw()
  cls(bgclr)
  
  map(0,0)
  if nu == 1 then
  	drawparts()
  end
  spr(player.sp,player.x,player.y,1,1,player.flp)
		
		fade()
		spr(16,map_start+1,cam_y,7,2)
  print(((time()-start)),map_start+3,cam_y+3,1)
end

function menudraw()
	cls()
	spr(12,48,44,4,4)
	print("press [enter] to pause",20,78,startclr)
	print("press ❎/🅾️ to start",24,88,startclr)
	fade()
end

function menuupdate()
	startgame()
	if btnp(❎) and start == false or btnp(🅾️) and start == false then
		start=true
		sfx(0)
	end
end

function startgame()
	val ="warp"
	if startclr == 12 then
	 menuitem(3,"⬅️ effects "..va.." ➡️",incdec2)
		menuitem(1,"⬅️ warp ➡️", incdec)
		menuitem(2,"warp to selected", warpto)
		_draw=playdraw
		_update=playupdate
		start = time()
	elseif start == true then
			startclr+=1
			fadedir = 1
	end
end

_draw = menudraw
_update = menuupdate

function incdec(b)
 if (b&1 > 0) num-=1
 if (b&2 > 0) num+=1
 
 --if num == 1 then val = "1: tree"end
 --if num == 2 then val = "2: candy"end
 --if num == 3 then val = "lvl pack 2"end
 --if num == 4 then val = "1: tree" num = 1end
 --if num <= 0 then val = "lvl pack 2" num = 3end
 --if num == 5 then val = "1: tree" num = 1end
 
 if num <= 0 then val = "2: candy" num = 2end
 if num == 1 then val = "1: tree"end
 if num == 2 then val = "2: candy"end
 if num >= 3 then val = "1: tree" num = 1end
 
 menuitem(1,"⬅️ "..val.." ➡️",incdec)

 return true
end

va = "on"
nu = 1
function incdec2(b)
 if (b&1 > 0) nu-=1
 if (b&2 > 0) nu+=1
 
 if nu <= 0 then va = "off" nu = 2end
 if nu == 1 then va = "on"end
 if nu == 2 then va = "off"end
 if nu >= 3 then va = "on" nu = 1end

 menuitem(3,"⬅️ effects "..va.." ➡️",incdec2)

 return true
end

function warpto()
	if val == "1: tree" then
		currentlevel=0
		lvlup(0)
	end
	
	if val == "2: candy" then
		currentlevel=8
		lvlup(8)
	end

	if val == "lvl pack 2" then
		currentlevel=17
		lvlup(17)
	end
end
-->8
--collisions

function collide_map(obj,aim,flag)
 --obj = table needs x,y,w,h
 --aim = left,right,up,down

 local x=obj.x  local y=obj.y
 local w=obj.w  local h=obj.h

 local x1=0	 local y1=0
 local x2=0  local y2=0

 if aim=="left" then
   x1=x-1  y1=y
   x2=x    y2=y+h-1

 elseif aim=="right" then
   x1=x+w-1    y1=y
   x2=x+w  y2=y+h-1

 elseif aim=="up" then
   x1=x+2    y1=y-1
   x2=x+w-3  y2=y

 elseif aim=="down" then
   x1=x+2      y1=y+h
   x2=x+w-3    y2=y+h
 end

 --pixels to tiles
 x1/=8    y1/=8
 x2/=8    y2/=8
	
 if fget(mget(x1,y1), flag)
 or fget(mget(x1,y2), flag)
 or fget(mget(x2,y1), flag)
 or fget(mget(x2,y2), flag) then
   return true
 else
   return false
 end

end
-->8
--player

function player_update()

		--level up
		if fadepos == 0 and collide_map(player,"down",7) or collide_map(player,"right",7) or collide_map(player,"down",7) then
			currentlevel+=1
			if va == "on" then
				fadedir=2
			else lvlup(currentlevel) end
		end
		--death
  if collide_map(player,"down",2) then
			spawnexplosion(player.x+4,player.y+4)
			lvlup(currentlevel)
  end
   
  if collide_map(player,"down",4) then
  	gravity = 0.1
  	player.max_dy=1
  else
  	gravity = 0.3
  	player.max_dy=3
  end
  --check for bouncr
  if collide_map(player,"down",3) then
			sfx(1)
			spawnpillpuft(player.x+4,player.y+4,2)
			player.dy = -6
		end
		
  --physics
  player.dy+=gravity
  player.dx*=friction

  --controls
  if btn(⬅️) then
    player.dx-=player.acc
    player.running=true
    player.flp=true
  end
  
  if btn(➡️) then
    player.dx+=player.acc
    player.running=true
    player.flp=false
  end

  --slide
  if player.running
  and not btn(⬅️)
  and not btn(➡️)
  and not player.falling
  and not player.jumping then
    player.running=false
    player.sliding=true
  end

  --jump
  if player.landed then
				spawnpuft(player.x+4,player.y+4)
    player.dy-=player.boost
    player.landed=false
  end
  
  --check collision up and down
  if player.dy>0 then
    player.falling=true
    player.landed=false
    player.jumping=false

    player.dy=limit_speed(player.dy,player.max_dy)

    if collide_map(player,"down",0) then
      player.landed=true
      player.falling=false
      player.dy=0
      player.y-=((player.y+player.h+1)%8)-1
    end
  elseif player.dy<0 then
    player.jumping=true
    if collide_map(player,"up",1) then
      player.dy=0
    end
  end

  --check collision left and right
  if player.dx<0 then

    player.dx=limit_speed(player.dx,player.max_dx)

    if collide_map(player,"left",1) then
      player.dx=0
    end
    if collide_map(player,"left",5) then
      player.dx=3
      player.dy = -3
    end
  elseif player.dx>0 then

    player.dx=limit_speed(player.dx,player.max_dx)

    if collide_map(player,"right",1) then
      player.dx=0
    end
    if collide_map(player,"right",5) then
      player.dx=-3
      player.dy = -3
    end
  end

  --stop sliding
  if player.sliding then
    if abs(player.dx)<.2
    or player.running then
      player.dx=0
      player.sliding=false
    end
  end

  player.x+=player.dx
  player.y+=player.dy

  --limit player to map
  if player.x<map_start then
    player.x=map_start
  end
  if player.x>map_end-player.w then
    player.x=map_end-player.w
  end
end

function player_animate()
	if player.dy < 0 then player.sp = 2
	elseif player.dy > 0 then player.sp = 3
	else player.sp = 1 end 
end

function limit_speed(num,maximum)
  return mid(-maximum,num,maximum)
end
-->8
--level up
function lvlup(level)
	player.dx = 0
	player.dy = 0
	map_top = 0
	bgclr=12
	map_bottom = 0
	if level != 0 and lastlevel < currentlevel then
		map_start += 128
		r_edge-=128
	end
	
	lastlevel = currentlevel
	
	player.dy = 0
	if level == 0 then
		player.x = 16
		player.y = 80
		r_edge = 1024
		map_start = 0
		cam_x = 0
		cam_y = 0
	end
		
	if level == 1 then
		player.x = 188
		player.y = 100
	end
	
	if level == 2 then
		player.x = 270
		player.y = 80
	end
	
	if level == 3 then
		player.x = 440
		player.y = 100
	end

	if level == 4 then
		player.x = 520
		player.y = 100
	end
	
	if level == 5 then
		player.x = 650
		player.y = 90
	end

	if level == 6 then
		player.x = 780
		player.y = 80
	end

	if level == 7 then
		player.x = 912
		player.y = 80
	end
	
	if level >= 8 and level <= 15 then
		map_top = 128
		bgclr = 13
		cam_x = 0
		cam_y = 128
	end

	if level == 8 then
		player.x = 16
		player.y = 208
		r_edge = 1024
		map_start = 0
	end

	if level == 9 then
		player.x = 144
		player.y = 144
	end

	if level == 10 then
		player.x = 264
		player.y = 216
	end

	if level == 11 then
		player.x = 488
		player.y = 160
	end

	if level == 12 then
		player.x = 568
		player.y = 236
	end

	if level == 13 then
		player.x = 648
		player.y = 208
	end

	if level == 14 then
		player.x = 776
		player.y = 200
	end

	if level == 15 then
		player.x = 904
		player.y = 208
	end
	
	if level == 16 then
		dset(0,1)
		endtime = time()-start
		_draw=enddraw
		_update=endupdate
	end
	
	if level == 17 then
		load("bean2.p8")
	end
end
-->8
--effects
function fade()
--add vars fadedir and fadepos
--constantly run fade
--fadedir -1 fade in 1 fade out
local fade,c,p={[0]=0,17,18,19,20,16,22,6,24,25,9,27,28,29,29,31,0,0,16,17,16,16,5,0,2,4,0,3,1,18,2,4}
  pal()
  for i=0,fadepos do
    if i%2==1 then
      for j=0,15 do
        c=peek(24336+j)
        if (c>=128) c-=112
        p=fade[c]
        if (p>=16) p+=112
        pal(j,p,1)
      end
    end
  end
  fadepos+=fadedir
  if fadedir > 0 then player.x = 256 player.y = 256 end
  if (fadepos<0) fadedir=0 fadepos=0
  if (fadepos>21) fadedir=-2 fadepos=21
		if fadedir < 0 then lvlup(currentlevel) end
end     

function addpart(_x,_y,_dx,_dy,_type,_maxage,_col,_s)
 local _p = {}
 _p.x=_x
 _p.y=_y
 _p.dx=_dx
 _p.dy=_dy
 _p.tpe=_type 
 _p.mage=_maxage
 _p.age=0
 _p.col=0
 _p.colarr=_col
 _p.rot=0
 _p.rottimer=0
 _p.s=_s
 _p.os=_s
 
 add(part,_p)
end
 
-- spawn a small puft
function spawnpuft(_x,_y)
 for i= 0,5 do
  local _ang = rnd()
  local _dx = sin(_ang)*1
  local _dy = cos(_ang)*1
  addpart(_x,_y,_dx,_dy,2,15+rnd(15),{7,6,5},1+rnd(2))
 end
end
 
-- spawn a puft in the color of a pill
function spawnpillpuft(_x,_y,_p)
 for i= 0,20 do
  local _ang = rnd()
  local _dx = sin(_ang)*(1+rnd(2))
  local _dy = cos(_ang)*(1+rnd(2))
  local _mycol
  
  if _p == 1 then
   -- slowdown -- orange
   _mycol={9,9,4,4,0}
  elseif _p == 2 then
   -- life -- white
   _mycol={7,7,6,5,0}
  elseif _p == 3 then
   -- catch -- green
   _mycol={11,11,3,3,0}
  elseif _p == 4 then
   -- expand -- blue
   _mycol={12,12,5,5,0}
  elseif _p == 5 then
   -- reduce -- black
   _mycol={0,0,5,5,6}
  elseif _p == 6 then
   -- megaball -- pink
   _mycol={14,14,13,2,0}
  else
   -- multiball -- red
   _mycol={8,8,4,2,0}
  end  
  addpart(_x,_y,_dx,_dy,2,20+rnd(15),_mycol,1+rnd(4))
 end
end
 
-- spawn death particles
function spawndeath(_x,_y)
 for i= 0,30 do
  local _ang = rnd()
  local _dx = sin(_ang)*(2+rnd(4))
  local _dy = cos(_ang)*(2+rnd(4))
  local _mycol
  
  _mycol={10,10,9,4,0}
  addpart(_x,_y,_dx,_dy,2,80+rnd(15),_mycol,3+rnd(6))
 end
end
 
-- spawn death particles
function spawnexplosion(_x,_y)
 --first smoke
 sfx(14)
 for i= 0,20 do
  local _ang = rnd()
  local _dx = sin(_ang)*(rnd(4))
  local _dy = cos(_ang)*(rnd(4))
  local _mycol
  _mycol={0,0,5,5,6}
  addpart(_x,_y,_dx,_dy,2,80+rnd(15),_mycol,3+rnd(6))
 end
 --fireball
 for i= 0,30 do
  local _ang = rnd()
  local _dx = sin(_ang)*(1+rnd(4))
  local _dy = cos(_ang)*(1+rnd(4))
  local _mycol
  _mycol={7,10,9,8,5}
  addpart(_x,_y,_dx,_dy,2,30+rnd(15),_mycol,2+rnd(4))
 end
 
end
 
-- spawn a trail particle
function spawntrail(_x,_y)
 if rnd()<0.5 then
  local _ang = rnd()
  local _ox = sin(_ang)*4*0.3
  local _oy = cos(_ang)*4*0.3
 
  addpart(_x+_ox,_y+_oy,0,0,0,15+rnd(15),{5,6},0)
 end
end
 
-- spawn a megatrail particle
function spawnmtrail(_x,_y)
 if rnd() then
  local _ang = rnd()
  local _ox = sin(_ang)*2
  local _oy = cos(_ang)*2
 
  addpart(_x+_ox,_y+_oy,0,0,2,20+rnd(15),{14,8,2},1+rnd(1))
 end
end

function updateparts()
 local _p
 for i=#part,1,-1 do
  _p=part[i]
  _p.age+=1
  if _p.age>_p.mage then
   del(part,part[i]) 
  else
   -- change colors
   if #_p.colarr==1 then
    _p.col = _p.colarr[1]
   else
    local _ci=_p.age/_p.mage
    _ci=1+flr(_ci*#_p.colarr)
    _p.col = _p.colarr[_ci]
   end
   
   --appy gravity
   if _p.tpe == 1 or _p.tpe == 3 then
    _p.dy+=0.05
   end
   
   --rotate
   if _p.tpe == 3 then
    _p.rottimer+=1
    if _p.rottimer>5 then
     _p.rot+=1
     if _p.rot>=4 then
      _p.rot=0
     end
    end
   end
   
   --shrink
   if _p.tpe == 2 then
    local _ci=1-(_p.age/_p.mage)
    _p.s=_ci*_p.os
   end
   
   --friction
   if _p.tpe == 2 then
             _p.dx=_p.dx/1.2
             _p.dy=_p.dy/1.2
   end
   
   --move particle
   _p.x+=_p.dx
   _p.y+=_p.dy
  end
 end  
end
 
-- big particle drawer
function drawparts()
 for i=1,#part do
  _p=part[i]
  -- pixel particle
  if _p.tpe == 0 or _p.tpe == 1 then
   pset(_p.x,_p.y,_p.col)
  elseif _p.tpe == 2 then
   circfill(_p.x,_p.y,_p.s,_p.col)
  elseif _p.tpe == 3 then
   local _fx,_fy
   if _p.rot==2 then
    _fx=false
    _fy=true
   elseif _p.rot==3 then
    _fx=true
    _fy=true
   elseif _p.rot==4 then
    _fx=true
    _fy=false
   else
    _fx=false
    _fy=false
   end
   
   spr(_p.col,_p.x,_p.y,1,1,_fx,_fy)
  end
 end  
end
__gfx__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070000700000000000000000000000000
00700700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070000700000777700000000000000000
00077000022222200222222002222220000000000000000000000000000000000000000000000000000000000000000077777777007000070077777007777000
00077000288888822878878228888882000000000000000000000000000000000000000000000000000000000000000070000000707000070700007070000700
00700700287887822888888228888882000000000000000000000000000000000000000000000000000000000000000070000000707777700700007070000700
00000000288888822888888228788782000000000000000000000000000000000000000000000000000000000000000070000000707000000700077070000700
00000000022222200222222002222220000000000000000000000000000000000000000000000000000000000000000077777777000777770077707070000700
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000222e0022e02e02e022e0022e222e000
16666666666666666666666666666666666666666666666100111110000000000000000000000000000000000000000002e02e2222e2e02e2222e222e2e00000
16666666666666666666666666666666666666666666666101166611000000000000000000000000000000000000000002e02e2e02e2e02e2e02e2e00222e000
1666666666666666666666666666666666666666666666610166166100000000000000000000000000000000000000000222e02e02e2e02e2e02e2e002e00000
16666666666666666666666666666666666666666666666101661161000000000000000000000000000000000000000002e02e2222e2222e2e02e222e2e00000
16666666666666666666666666666666666666666666666101666661000000000000000000000000000000000000000002222e022e0022e02e02e022e222e000
16666666666666666666666666666666666666666666666101166611000000000000000000000000000000000000000000000000000000000000000000000000
16666666666666666666666666666666666666666666666100111110000000000000000000000000000000000000000000000000000000003333333333333333
01111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000003333333333333333
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000222222000000b3b3b33bb3b3b33b
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002878878200000439b7bb9439b7bb9
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000028888882000004b9974994b997499
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000028888882000004499949944999499
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002222220000004444444944444449
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004444444444444444
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007077070000004999977749999777
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007077070000004499999744999997
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007070070000004444449744444497
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000707070070700004497749944977499
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070077007000004499749944997499
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000033333333333333334499949944999499
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000033333333333333334444444944444449
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b3b3b33bb3b3b33b4444444444444444
49999777333333338eeee77711111111000000000000000000000000000000000000000000000000000000444400000000003330000000000004544544540000
449999973333333388eeeee711111111000000000000000000000000000000000000000000000000003338043333330000033333000330000000454545400000
44444497b3b3b33b888888e7d1d1d11d00000000000000000000000000000000000000000000000003333333333383300333b3b3333333000000044444000000
44977499439b7bb988e778ee81ed7dde000000000000000000000000000000000000000000000000333333333333333033333b3333b330000000044444000000
449974994b99749988ee78ee8dee78ee000000000000000000000000000000000000000000000000333833333333333003b3b3333bb330000000045440000000
449994994499949988eee8ee88eee8ee0000000000000000000000000000000000000000000000003333333383333300003b3333333333000000045540000000
44444449444444498888888e8888888e00000000000000000000000000000000000000000000000033333333333338300333333b3b3333000000045540000000
44444444444444448888888888888888000000000000000000000000000000000000000000000000033333383333333000333333b33330000000044444000000
00444444444444444444440000700000000000000000000000000000000000000000000000000000003333333338333000000000000000000000044444000000
04999999999999999999774000700000a000000a0000000000000000000000000000000000000000003383333333330000033333000000000000004443333000
49994444444444444444977400700000aa09a09a0000000000000000000000000000000000000000003333330333300000b3b333300000000000333333333330
499944444444444444449994007000009aa9aa9a00000000000000000000000000000000000000000003333000000000033b33333300000000333b3333333330
049999999999999999999940008888009998e99900000000000000000000000000000000000000000000000000000000033333b3b33333300033b3b333333333
00444444444444444444440000888000999e8999000000000000000000000000000000000000000000000000000000000333333b333333330033333333b33333
0000000000000000000000000078000099999999000000000000000000000000000000000000000000000000000000000333333333333b3b000033333b3b3333
00000000000000000000000000000000aaaaaaaa0000000000000000000000000000000000000000000000000000000000333333333333b30003333333333333
007000700007700000000077666666677700000000000000003333000099990000000000008788000000000000000000000333333333333300333333333333b3
000700070006700000007776666666776777000000222200033bbb30099aaa9000999900088778800000000000000000000033333b3b33330333333333333b3b
70007000006677000077766606666670666777000222222033b333b399a999a9099999900870007700000000000000000033333333b333330333333b33333333
070007000066670077766666066667706666677702e22e2033b3b33b99a9a99a09a99a900770007800000000000000000033b3b333333333033333b3b3333330
007000700666677076666666006667006666666702e22e2033b33b3b99a99a9a09a99a9007000088000333300000000000333b3333333330033b333333000000
000700070666667000666666006677006666660002e22e20333bb33b999aa99a09a99a90000000870033333303333000000033333333333000b3b33330000000
700070006666667700006666000670006666000002e22e20033333b0099999a009a99a9000000077003383333333330000000044433330000003333300000000
070007006666666700000066000770006600000002e22e2000333b0000999a0009a99a9000000078003333333338333000000444440000000000000000000000
088888800000000000000000111111117777777702e22e20008888000004400009a99a9000000088033333383333333000000444440000000000000000000000
8888888e0101010100008700111111117700070702e22e20088eee800004400009a99a9000000087333333333333383000000455400000000000000000000000
8888888e0000000000088800111111117070007702e22e2088e888e80004400009a99a9000000077333333338333330000000455400000000000000000000000
888eeeee101010100088880011111111700700070222222088e8e88e000440000999999000000078333833333333333000000454400000000000000000000000
01111110010101010000070011111111700070070004400088e88e8e000440000004400000000088333333333333333000000444440000000000000000000000
1dddddd11111111100000700111111117700070700044000888ee88e000440000004400000000087033333333333833000000444440000000000000000000000
011111101111111100000700111111117070007700044000088888e0000440000004400000000077003338043333330000004545454000000000000000000000
1dddddd1111111110000070011111111777777770004400000888e00000440000004400000000078000000444400000000045445445400000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000aa00000a00000aa000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000009aa0009aa00099a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000099aa0999aa0999a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000999aa98eeaa999a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000009999998e899999a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000099999988e999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000999999999999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000009aaaaaaaaaaaaa9000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000a2222222222222a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000287788888887782000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000287788888887782000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000288888888888882000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000288888888888882000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000288888888888882000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000288888888888882000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000288888888888882000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000022222222222220000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__label__
49999777499997774999977749999777499997774999977749999777499997774999977749999777499997774999977749999777499997774999977749999777
44111111111111111111111111111111111111111111111144999997449999974499999744999997449999974499999744999997449999974499999744999997
41666666666666666666666666666666666666666666666614411111444444974444449744444497444444974444449744444497444444974444449744444497
41616161116666611161116111611166666666666666666614116661149774994497749944977499449774994497749944977499449774994497749944977499
41616161616666616666616661666166666666666666666614166166149974994499749944997499449974994499749944997499449974994499749944997499
41611161116666611166116611661166666666666666666614166116149994994499949944999499449994994499949944999499449994994499949944999499
41666166616666666166616661666166666666666666666614166666144444494444444944444449444444494444444944444449444444494444444944444449
41666166616616611161116111611166666666666666666614116661144444444444444444444444444444444444444444444444444444444444444444444444
4166666666666666666666666666666666666666666666661cc11111ccc454454454cccc49999777cccccccccccccccccccccccccccccccccccccccc49999777
700000007770707077708888011111111111111111111111cccccccccccc4545454ccccc44999997cccccccccccccccccccccccccccccccccccccccc44999997
0700000070007070707088880ccccccccccccccc44444497ccccccccccccc44444cccccc44444497cccccccccccccccccccccccccccccccccccccccc44444497
0070000077000700777088880ccccccccccccccc44977499ccccccccccccc44444cccccc44977499cccccccccccccccccccccccccccccccccccccccc44977499
0700000070007070700088880ccccccccccccccc44997499ccccccccccccc4544ccccccc44997499cccccccccccccccccccccccccccccccccccccccc44997499
7000000077707070700088880ccccccccccccccc44999499ccccccccccccc4554ccccccc44999499cccccccccccccccccccccccccccccccccccccccc44999499
0000000000000000000000000ccccccccccccccc44444449ccccccccccccc4554ccccccc44444449cccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccc44444444ccccccccccccc44444cccccc44444444cccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccc49999777ccccccccccccc44444cccccc49999777cccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccc44999997cccccccccccccc4443333ccc44999997cccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccc44444497cccccccccccc33333333333c44444497cccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccc44977499cccccccccc333b333333333c44977499cccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccc44997499cccccccccc33b3b33333333344997499cccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccc44999499cccccccccc33333333b3333344999499cccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccc44444449cccccccccccc33333b3b333344444449cccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccc44444444ccccccccccc333333333333344444444cccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccc66666667cccccccccc333333333333b366666667cccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccc66666677ccccccccc333333333333b3b66666677cccccccccccccccccccccccccccccccccccccccc44999997
44444497ccccccccccccccccccccccccccccccccc666667cccccccccc333333b33333333c666667ccccccccccccccccccccccccccccccccccccccccc44444497
44977499ccccccccccccccccccccccccccccccccc666677cccccccccc33333b3b333333cc666677ccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccc6667ccccccccccc33b333333cccccccc6667cccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccc6677ccccccccccccb3b3333ccccccccc6677cccccccccccccccccccccccccccccccccccccccccc44999499
44444449ccccccccccccccccccccccccccccccccccc67cccccccccccccc33333ccccccccccc67ccccccccccccccccccccccccccccccccccccccccccc44444449
44444444ccccccccccccccccccccccccccccccccccc77cccccccccccccccccccccccccccccc77ccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444ccccccccccccccccccccccccc222222ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccc28888882ccc77cccccccccccccccccccccccccccccc77ccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccc28888882ccc67cccccccccccccccccccccccccccccc67ccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccc28788782cc6677cccccccccccccccccccccccccccc6677cccccccccccccccccccccccccccccccccccccccccc44444497
44977499ccccccccccccccccccccccccc222222ccc6667cccccccccccccccccccccccccccc6667cccccccccccccccccccccccccccccccccccccccccc44977499
44997499ccccccccccccccccccccccccccccccccc666677cccccccccccccccccccccccccc666677ccccccccccccccccccccccccccccccccccccccccc44997499
44999499ccccccccccccccccccccccccccccccccc666667cccccccccccccccccccccccccc666667ccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccc66666677cccccccccccccccccccccccc66666677cccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccc66666667cccccccccccccccccccccccc66666667cccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccc49999777cccccccccccccccccccccccc49999777cccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccc44999997cccccccccccccccccccccccc44999997cccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccc44444497cccccccccccccccccccccccc44444497cccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccc44977499cccccccccccccccccccccccc44977499cccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccc44997499cccccccccccccccccccccccc44997499cccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccc44999499cccccccccccccccccccccccc44999499cccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccc44444449cccccccccccccccccccccccc44444449cccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccc44444444cccccccccccccccccccccccc44444444cccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccc49999777cccccccccccccccccccccccc49999777cccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccc44999997cccccccccccccccccccccccc44999997cccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccc44444497cccccccccccccccccccccccc44444497cccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccc44977499cccccccccccccccccccccccc44977499cccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccc44997499cccccccccccccccccccccccc44997499cccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccc44999499cccccccccccccccccccccccc44999499cccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccc44444449cccccccccccccccccccccccc44444449cccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccc44444444cccccccccccccccccccccccc44444444cccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccc49999777cccccccccccccccccccccccc49999777cccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccc0c44999997cccccccccccccccccccccccc44999997cccccccccccccccccccccccccccccccccccccccc44999997
44444497ccccccccccccccccccccccccc0cccccc44444497cccccccccccccccccccccccc44444497cccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccc44977499cccccccccccccccccccccccc44977499cccccccccccccccccccccccccccccccccccccccc44977499
44997499ccccccccccccccccccccccccccc0cccc44997499cccccccccccccccccccccccc44997499cccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccc0ccccc44999099cccccccccccccccccccccccc44999499cccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccc44444449cccccccccccccccccccccccc44444449cccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccc44444444cccccccccccccccccccccccc44444444cccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccc49999777cccccccccccccccccccccccc49999777cccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccc44999997cccccccccccccccccccccccc44999997cccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccc44444497cccccccccccccccccccccccc44444497cccccccccccccccccccccccccccccccccccccccc44444497
44977499ccccccccccccccccc0cccccccccccccc44977499cccccccccccccccccccccccc44977499cccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccc44997499cccccccccccccccccccccccc44997499cccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccc44999490cccccccccccccccccccccccc44999499cccccccccccccccccccccccccccccccccccccccc44999499
44444449ccccccccccccccc0cccccccccccccccc44404449cccccccccccccccccccccccc44444449cccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccc44444444cccccccccccccccccccccccc44444444cccccccccccccccccccccccccccccccccccccccc44444444
49999777ccccccccccccccccccccccccc888888c49999777c888888cc888888cc888888c49999777cccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccc8888888e449999978888888e8888888e8888888e44999997cccccccccccccccccccc87cccccccccccccccccc44999997
44444497cccccccccccccccccccccccc8888888e444444978888888e8888888e8888888e44444497ccccccccccccccccccc888cccccccccccccccccc44444497
44977499cccccccccccccccccccccccc888eeeee44977499888eeeee888eeeee888eeeee44977499cccccccccccccccccc8888cccccccccccccccccc44977499
44997499ccccccccccccccccccccccccc111111c44997499c111111cc111111cc111111c44997499ccccccccccccccccccccc7cccccccccccccccccc44997499
44999499cccccccccccccccccccccccc1dddddd1449994991dddddd11dddddd11dddddd144999499ccccccccccccccccccccc7cccccccccccccccccc44999499
44444449ccccccccccccccccccccccccc110111c44444449c111111cc111111cc111111c44444449ccccccccccccccccccccc7cccccccccccccccccc44444449
44444444cccccccccccccccccccccccc1dddddd1444444441dddddd11dddddd11dddddd144444444ccccccccccccccccccccc7cccccccccccccccccc44444444
49999777333333333333333333333333499997773333333333333333333333333333333333333333cccccccccccccccc33333333cccccccccccccccc49999777
44999997333333333333333333333333449999973333333333333333333333333333333333333333cccccccccccccccc33333333cccccccccccccccc44999997
44444497b3b3b33bb3b3b33bb3b3b33b44444497b3b3b33bb3b3b33bb3b3b33bb3b3b33bb3b3b33bccccccccccccccccb3b3b33bcccccccccccccccc44444497
44977499439b7bb9439b7bb9439b7bb944977499439b7bb9439b7bb9439b7bb9439b7bb9439b7bb9cccccccccccccccc439b7bb9cccccccccccccccc44977499
449974994b9974994b9974994b997499449974994b9974994b9974994b9974994b9974994b997499cccccccccccccccc4b997499cccccccccccccccc44997499
44999499449994994499949944999499449994994499949944999499449994994499949944999499cccccccccccccccc44999499cccccccccccccccc44999499
44444449444444494444444944444449444444494444444944444449444444494444444944444449cccccccccccccccc44444449cccccccccccccccc44444449
44444444444444444444444444444444444444444444444444444444444444444444444444444444cccccccccccccccc44444444cccccccccccccccc44444444
49999777499997774999977749999777499997774999977749999777499997774999977749999777cccccccccccccccc49999777cccccccccccccccc49999777
44999997449999974499999744999997449999974499999744999997449999974499999744999997c1c1c1c1c1c1c1c144999997c1c1c1c1c1c1c1c144999997
44444497444444974444449744444497444444974444449744444497444444974444449744444497cccccccccccccccc44444497cccccccccccccccc44444497
449774994497749944977499449774994497749944977499449774994497749944977499449774991c1c1c1c1c1c1c1c449774991c1c1c1c1c1c1c1c44977499
44997499449974994499749944997499449974994499749944997499449974994499749944997499c1c1c1c1c1c1c1c144997499c1c1c1c1c1c1c1c144997499
44999499449994994499949944999499449994994499949944999499449994994499949944999499111111111111111144999499111111111111111144999499
44444449444444494444444944444449444444494444444944444449444444494444444944444449111111111111111144444449111111111111111144444449
44444444444444444444444444444444444444444444444444444444444444444444444444444444111111111111111144444444111111111111111144444444
49999777499997774999977749999777499997774999977749999777499997774999977749999777111111111111111149999777111111111111111149999777
44999997449999974499999744999997449999974499999744999997449999974499999744999997111111111111111144999997111111111111111144999997
44444497444444974444449744444497444444974444449744444497444444974444449744444497111111111111111144444497111111111111111144444497
44977499449774994497749944977499449774994497749944977499449774994497749944977499111111111111111144977499111111111111111144977499
44997499449974994499749944997499449974994499749944997499449974994499749944997499111111111111111144997499111111111111111144997499
44999499449994994499949944999499449994994499949944999499449994994499949944999499111111111111111144999499111111111111111144999499
44444449444444494444444944444449444444494444444944444449444444494444444944444449111111111111111144444449111111111111111144444449
44444444444444444444444444444444444444444444444444444444444444444444444444444444111111111111111144444444111111111111111144444444

__gff__
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000303030300000000000000000000000001010180800000000000000000000000100404040400000000000000000000000a048004210000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
4040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040
4000000000000000000000000000004040000000000000000000000000000040400000004000000000000000000000404000000000530040400053004e4f0040400000000040004e4f40000000000040400000000000000000000000000000404000000000000000000000000000004040000000000000000000000000000040
4000000000000000000000000000004040000000000000000000000000000040400000004000000000000000000000404000000000000063630000005e5f0040400000000040005e5f40000000000040400000000000000000000000000000404000000000000000000000000000004040000000000000000000000000000040
400000000000000000000000000000404072000000005c5d0000000000007240400000004000000000000000000000404000000000000000000000006e6f0040400000000063006e6f63000000000040400000000000000000000000000000404000000000000000000000000000004040000000000000000000000000000040
400000000000000000000000000000404041410000006c6d0000000000414140400000004000000000000000000000404000000000000000000000000000004040000000000000000000000000000040400000000000000000000000720000404000000000000000000000000000004040000000000000000000000000000040
400000000000000000000000000000404000000000007c7d0000000000000040400000004000000000000000000000404000000000000000000000000000004040000000000000000000000000000040400000000000000000505151515200404000000000000000000000000000004040000000000000000000000000000042
4000000000000000000000000000004040000000000041414141000000000040400000006300000000000000000000404000000000000000000000000000004040000000000000000000000000000040406161610000000000000000000000404000000000000000000000000000004040000000000000000000000000000042
4000000000000000000000000000004040000000000000000000000000000040400000000000000000000000000000404000000000000070700000000000004040000000006100000061000000000040405151515200000000000000000000404000000000000000000000000000004040000000000000000000000000000042
4000000000000000000000000000004040000000000000000000000000000040400000000000000000000000000000404000000000000040400000000000004040000000004000000040000000000040400000000000000000000000000000404000000000000000000000000000004040000000000000000000000000000042
400000005c5d000000000000000000404000000000000000000000000000004040000000000000000000000000000040400000000000000000000000000000404000000000400000004000000000004040005c5d0000000000000000000000404000000000000000000000000000004040000000000000000000000000000042
400000006c6d0000000000000000004040000000004151515151414c4d00004040006a6b610000000000000000720040400000000000000000000000000000404000000000400000004000000000004040006c6d0000505152000000000000404000000000000000000000000000004040000000000000000000000000720042
400000007c7d0000000000000072004040700000004000000000407c7d00704040007a7b404141410000000041414140400000000000000000000000000000404000000000400000004000000000004040007c7d0000000000000000000000404000000000000000000000000072004040000000414141000000434343434342
4041414141414100000041414141414040414141414000000000404141414140404141414040404000000000404040404000000000000000006a6b000000004040000000704070707040000072000040404141410000000000000000000000404041414141000000000000414141414040414141404040717171424242424242
4040404040404071717140404040404040404040404000000000404040404040404040404040404071717171404040404070000000000000007a7b000000704040414141404141414141000041000040404040407171717171717171717171404040404040717171717171404040404040404040404040737373424242424242
4040404040404073737340404040404040404040404070000000404040404040404040404040404073737373404040404041410000414141414141000041414040404040404040404040717140717140404040407373737373737373737373404040404040737373737373404040404040404040404040737373424242424242
4040404040404040404040404040404040404040404041414141404040404040404040404040404073737373404040404040407171404040404040717140404040404040404040404040737340737340404040407373737373737373737373404040404040737373737373404040404040404040404040737373424242424242
4242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242
4200000000000000000000000000004242000000004200000000000000000042420000000000000000000000000000424242424242424242000000000000004242000000000000000000000000000042420000000000000000000000000000424242424242424242424242424242424242000000000000000000000000000042
4200000000000000000000000000004242000000004200000000000000000042420000000000000000000000000000424242424242424242006060000000004242000000000000000000000000000042420000000000000000000000000000424242420000000000000000000042424242000000000000000000000000000042
4200000000000000000000000000004242434360604272000060600000000042420000000000000000000000000000424242424242424242006060000000654242000000680000606000000000000042420000000067000000000065000000424242420000000000000000000042424242000000000000006060606000000042
4200000000000000000000000000004242424260604243430060600000000042420000000000000000000000000000424242424242424242006060000000754242007200780000606000000000720042420072000077000000000075006000424200000000000000000000000000004242000000000000606060606000000042
4200000000000000000000000000004242606060604242420060600000000042420000000000000000000000000000424242424242424242006060004343434242434343434300606000434343434342424343434343430000004343006000424200000000600061000000000000004242000000000060606000000000000042
4200000000000000000000000000004242606060604200000060600000000042420000000000000000000000000000424200000000000000006060004242424242000000000000606000000000000042420000000000000000000000006000424200000000600042000000000000004242000000006060600000000000000042
4200000000000000000000000000004242606061614200000060600000690042420000000060606060606000000000424200000000000000006060004242424242000000000000606000000000000042420000000000000000000000006000424200000000600042000000000000004242000000606060000000000000540042
4200000000000000000000000000004242606043434200000060600000790042420000006060606060606060000000424200000000000000000000004242424242000000000000606000760000000042420000000000000000000000006000424200000000600000000000000000004242000060606000000000000043434342
4200000000000060600000000000004242606060604200000060600043434342420000606060600000606060600000424200000000000000616161614242424242606060000000000000770060606042420000000000007600000000006000424200000000000000000000000072004242000060600000000000000042424242
4200000000000060600000000072004242606060604200000060600042424242420066606000000000000060600000424200000000000000424242424242424242606060434343434343434360606042420000000000007700000000000000424243434343000000000000434343434242000000000000000000000042424242
4200000000000060600043434343434242616100004200000060600042424242420077000000000000000000000072424200000000006161424242424242424242606060000000000000000060606042424343000000434300000000434343424242424242000000000000424242424242434300000000000000000042424242
4200000000000060600042424242424242434300000000000060600042424242424343000000000000000000004343424200000067004242424242424242424242606060000000000000000060606042424242000000424200000000424242424242424242717171717171424242424242424200000000000000000042424242
4200000069000000000042424242424242424200006800000060600042424242424242000000000000000000004242424200720077004242424242424242424242000000000000000000000000000042424242717171424271717171424242424242424242737373737373424242424242424271717171717171717142424242
4200000079000000000042424242424242424200007800000000000042424242424242717171717171717171714242424243434343434242424242424242424242616161000000000000000061616142424242737373424273737373424242424242424242737373737373424242424242424273737373737373737342424242
4243434343434343434342424242424242424243434343434343434342424242424242737373737373737373734242424242424242424242424242424242424242434343434343434343434343434342424242737373424273737373424242424242424242737373737373424242424242424273737373737373737342424242
__sfx__
00050000095500955009550095500d5500d5500e5500e5500e5500e5500e550061000610006100061000610016500061000610006100061000610005100135000510005100051000610006100061000610006100
0001000001500005000050000500005000050001500025000250004500055000650007500095000b5000c5000e500115001350016500185001a5001d5002150024500265002a5002f500355003d5003f5001a000
000800002000020000200002000020000200001b0001b0001b0001b0001b0001b0001b0001b000190001900019000190001900019000140001400014000140001400014000140001400015000150001500015000
000800001900019000190001900023000230002300023000210002100021000210002000020000200002000020000200001e0001e0001e0001e0001e0001e0001e0001e0001e0001e0001e0001e0001e0001e000
000800002000020000200002000020000200001b0001b0001b0001b0001b0001b0001b0001b000190001900019000190001900019000140001400014000140001400017000170001700017000150001500015000
000800001500015000150001500015000150001500015000150001500015000180001800018000180001800018000180001800018000180001800018000180001800018000180001800018000180001800018000
000800002000020000200002000020000200002100021000210002100021000230002300023000230002a0002a0002a0002a0002a0002a0002800028000280002800028000280002300023000230002300023000
0010000025000250002500025000250002500023000230002100020000200001e0001c0001b00019000190001c00019000190001c0001900019000190001900017000170001900017000190001c0002000020000
00100000210002000020000210002000020000200002000019000190001e0001c0001b000190001b0001b0001c0001e0001e000200001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b000
001000001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b00019000190001c00019000190001c0001900019000190001900017000170001900017000190001c0002000020000
001000001e0001e000200002300023000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001300002300023000230002300023000230002300023000200002000021000210002100020000200002000021000210002000020000200001e0001e0001e0001e00020000200002000021000210002100023000
00100000230001c0001c0001c0001c0001900019000190001b0001b0001b0001c0001c0001e0001e0001b00019000190001b00019000190001700017000170001700017000170001700017000170001700017000
00100000200002000021000210002100020000200002000021000210002000020000200001e0001e0001e0001e00020000200002000021000210002100023000230002a0002a0002a00028000280002800023000
001000002300023000230002500025000250002500025000250002500025000250002500025000250002500025000270002700027000270002700027000270002700027000270002700027000270002700027000
__music__
00 42424344
00 43424344
00 44424344
00 45444344
00 42424344
00 43424344
00 46424344
00 47424344
00 48424344
00 49424344
00 4b424344
00 4b424344
00 4c424344
00 4d424344
00 4e424344

